using System;
using System.Collections.Generic;
using System.Linq;

public class Resenje
{
    public class Jarbol
    {
        public long X { get; set; }
        public long H { get; set; }
        public int OriginalniIndeks { get; set; }
    }

    public static void Pokreni()
    {
        string prvaLinija = Console.ReadLine();
        if (string.IsNullOrEmpty(prvaLinija) || !int.TryParse(prvaLinija, out int n)) return;

        long[] xKoordinate;
        try
        {
            xKoordinate = Array.ConvertAll(Console.ReadLine().Split(' ', StringSplitOptions.RemoveEmptyEntries), long.Parse);
        }
        catch { return; }

        long[] hVisine;
        try
        {
            hVisine = Array.ConvertAll(Console.ReadLine().Split(' ', StringSplitOptions.RemoveEmptyEntries), long.Parse);
        }
        catch { return; }

        var jarboli = new Jarbol[n];
        for (int i = 0; i < n; i++)
        {
            jarboli[i] = new Jarbol { X = xKoordinate[i], H = hVisine[i], OriginalniIndeks = i };
        }

        Array.Sort(jarboli, (a, b) => a.X.CompareTo(b.X));

        var rezultati = new long[n];
        for (int i = 0; i < n; i++)
        {
            rezultati[i] = -1;
        }

        var stekL = new Stack<int>();

        for (int k = 0; k < n; k++)
        {
            var jarbolK = jarboli[k];
            long ZK = jarbolK.X + jarbolK.H;

            while (stekL.Count >= 2)
            {
                var j1_idx = stekL.Pop();
                var j0_idx = stekL.Peek();
                
                var j1 = jarboli[j1_idx];
                var j0 = jarboli[j0_idx];

                long z1 = j1.X + j1.H;
                long z0 = j0.X + j0.H;
                long x1 = j1.X;
                long x0 = j0.X;

                if ((z1 - z0) * (jarbolK.X - x0) <= (ZK - z0) * (x1 - x0))
                {
                    
                }
                else
                {
                    stekL.Push(j1_idx);
                    break;
                }
            }
            
            long minimalnaUdaljenostL = -1;
            
            if (stekL.Count > 0)
            {
                var najboljiJarbolI = jarboli[stekL.Peek()];
                long sumaI = najboljiJarbolI.X + najboljiJarbolI.H;

                long udaljenostL = Math.Abs(ZK - sumaI);
                minimalnaUdaljenostL = udaljenostL;
            }

            if (minimalnaUdaljenostL != -1 && (rezultati[jarbolK.OriginalniIndeks] == -1 || minimalnaUdaljenostL < rezultati[jarbolK.OriginalniIndeks]))
            {
                rezultati[jarbolK.OriginalniIndeks] = minimalnaUdaljenostL;
            }

            stekL.Push(k);
        }

        var stekR = new Stack<int>();

        for (int k = n - 1; k >= 0; k--)
        {
            var jarbolK = jarboli[k];
            long WK = jarbolK.X - jarbolK.H;

            while (stekR.Count >= 2)
            {
                var j1_idx = stekR.Pop();
                var j0_idx = stekR.Peek();

                var j1 = jarboli[j1_idx];
                var j0 = jarboli[j0_idx];

                long w1 = j1.X - j1.H;
                long w0 = j0.X - j0.H;
                long x1 = j1.X;
                long x0 = j0.X;

                if ((w1 - w0) * (jarbolK.X - x0) >= (WK - w0) * (x1 - x0))
                {
                    
                }
                else
                {
                    stekR.Push(j1_idx);
                    break;
                }
            }

            long minimalnaUdaljenostR = -1;
            
            if (stekR.Count > 0)
            {
                var najboljiJarbolI = jarboli[stekR.Peek()];
                long razlikaI = najboljiJarbolI.X - najboljiJarbolI.H;

                long udaljenostR = Math.Abs(WK - razlikaI);
                minimalnaUdaljenostR = udaljenostR;
            }

            if (minimalnaUdaljenostR != -1)
            {
                if (rezultati[jarbolK.OriginalniIndeks] == -1 || minimalnaUdaljenostR < rezultati[jarbolK.OriginalniIndeks])
                {
                    rezultati[jarbolK.OriginalniIndeks] = minimalnaUdaljenostR;
                }
            }

            stekR.Push(k);
        }

        foreach (var res in rezultati)
        {
            Console.WriteLine(res);
        }
    }

    public static void Main(string[] args)
    {
        Pokreni();
    }
}